<?php
ob_start();
session_start();
error_reporting(0);
require_once('../include/dbconnect.php');

if (!isset($_SESSION['admin'])) {
    header("Location: login/login.php");
    exit();
}

$data = file_exists('contact_data.json') ? json_decode(file_get_contents('contact_data.json'), true) : [];

$contactUpdated = $data['contact_updated'] ?? null;
$walletUpdated = $data['wallet_updated'] ?? null;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Update Contact & Wallet Info</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', sans-serif;
        background: #f4f6f9;
        margin: 0;
        padding: 0;
    }

    .header {
        background: #5e72e4;
        color: white;
        padding: 15px 30px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
    }

    .header a {
        color: #fff;
        text-decoration: none;
        font-weight: bold;
        background: rgba(255,255,255,0.15);
        padding: 8px 14px;
        border-radius: 6px;
        transition: 0.3s;
    }

    .header a:hover {
        background: rgba(255,255,255,0.25);
    }

    .container {
        max-width: 100%;
        width: 90%;
        background: #ffffff;
        margin: 30px auto;
        padding: 30px 20px;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    }

    h2 {
        text-align: center;
        color: #333;
        margin-bottom: 10px;
        font-size: 1.5rem;
    }

    .updated {
        text-align: center;
        font-size: 0.9rem;
        color: #888;
        margin-bottom: 25px;
    }

    label {
        font-weight: 500;
        display: block;
        margin-top: 20px;
        margin-bottom: 5px;
        color: #555;
    }

    input[type="text"],
    input[type="email"],
    textarea {
        width: 100%;
        padding: 12px 15px;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 16px;
        transition: border-color 0.3s;
    }

    input:focus,
    textarea:focus {
        border-color: #5e72e4;
        outline: none;
    }

    textarea {
        resize: vertical;
    }

    button {
        margin-top: 25px;
        background-color: #5e72e4;
        color: white;
        border: none;
        padding: 14px;
        border-radius: 8px;
        font-size: 16px;
        cursor: pointer;
        width: 100%;
        transition: background-color 0.3s;
    }

    button:hover {
        background-color: #3c54c4;
    }

    .form-divider {
        margin-top: 60px;
        margin-bottom: 20px;
        border-top: 1px dashed #ccc;
    }

    @media (max-width: 768px) {
        .header {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .container {
            width: 95%;
            padding: 25px 15px;
        }

        h2 {
            font-size: 1.3rem;
        }

        button {
            font-size: 15px;
        }
    }
  </style>
</head>
<body>

  <div class="header">
    <div><strong>Admin Panel</strong></div>
    <a href="index.php">&larr; Back to Dashboard</a>
  </div>

  <div class="container">
    <h2>Update Contact Information</h2>
    <div class="updated">Last Updated: <?= $contactUpdated ? date("F j, Y, g:i a", strtotime($contactUpdated)) : 'Never' ?></div>

    <form method="post" action="save_contact.php">
      <label for="phone">Phone Number:</label>
      <input type="text" id="phone" name="phone" value="<?= htmlspecialchars($data['phone'] ?? '') ?>">

      <label for="email">Email Address:</label>
      <input type="email" id="email" name="email" value="<?= htmlspecialchars($data['email'] ?? '') ?>">

      <label for="livechat">Live Chat Script:</label>
      <textarea id="livechat" name="livechat" rows="6"><?= htmlspecialchars($data['livechat'] ?? '') ?></textarea>

      <button type="submit">Save Contact Info</button>
    </form>

    <div class="form-divider"></div>

    <h2>Update Wallet Addresses</h2>
    <div class="updated">Last Updated: <?= $walletUpdated ? date("F j, Y, g:i a", strtotime($walletUpdated)) : 'Never' ?></div>

    <form method="post" action="save_wallet.php">
      <label for="btc">Bitcoin (BTC) Address:</label>
      <input type="text" id="btc" name="btc" value="<?= htmlspecialchars($data['btc'] ?? '') ?>">

      <label for="usdt">USDT (TRC20) Address:</label>
      <input type="text" id="usdt" name="usdt" value="<?= htmlspecialchars($data['usdt'] ?? '') ?>">

      <button type="submit">Save Wallet Info</button>
    </form>
  </div>

</body>
</html>
