<?php
$data = json_decode(file_get_contents('CapMDash/contact_data.json'), true);
?>

<!DOCTYPE html>
<html lang="zxx">
    <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Meta Description for Online Banking -->
    <meta name="description" content="Experience a fast & secure transaction with Newage Union Bank. Manage your finances, transfer funds, and access banking services anytime, anywhere.">
    <meta name="keywords" content="Online Banking, Secure Banking, Financial Services, Newage Union Bank">
    <meta name="author" content="Newage Union Bank">
    
    <!-- Links Of CSS File -->
    <link rel="stylesheet" href="css/css-bootstrap.min.css">
    <link rel="stylesheet" href="css/css-owl.theme.default.min.css">
    <link rel="stylesheet" href="css/css-owl.carousel.min.css">
    <link rel="stylesheet" href="css/css-flaticon.css">
    <link rel="stylesheet" href="css/css-remixicon.css">
    <link rel="stylesheet" href="css/css-meanmenu.min.css">
    <link rel="stylesheet" href="css/css-animate.min.css">
    <link rel="stylesheet" href="css/css-odometer.min.css">
    <link rel="stylesheet" href="css/css-style.css">
    <link rel="stylesheet" href="css/css-responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="images/newage.png">
    
    <!-- Title -->
    <title>Newage Union Bank - Online Bank</title>
</head>
    <body>
        <div id="google_translate_element"></div>

<script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL}, 'google_translate_element');
}
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        <style>
         .banner-area {
  background-size: cover;
  background-position: center;
  height: 100vh;
  background-image: url('image1.jpg');
  animation: slideBackground 20s infinite;
}

@keyframes slideBackground {
  0% {
    background-image: url('images/banners-3.jpg');
  }
  33% {
    background-image: url('images/banners-4.jpg');
  }
  66% {
    background-image: url(images/banners-1.png');
  }
  100% {
    background-image: url('images/banners-3.jpg');
  }
}

.background-slider {
  position: relative;
  width: 100%;
  height: 100vh;
}

.background-slider img {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  object-fit: cover;
  display: none;
}

    .help-section {
      background-color: #23233f;
      color: white;
      text-align: center;
      padding: 40px 20px;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .help-section h2 {
      font-size: 1.8em;
      margin-bottom: 30px;
    }

    .help-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
      gap: 30px;
      justify-items: center;
    }

    .help-card {
      background: transparent;
      padding: 15px;
      border-radius: 10px;
      transition: transform 0.2s ease;
      cursor: pointer;
    }

    .help-card:hover {
      transform: translateY(-5px);
    }

    .help-card i {
      font-size: 48px;
      margin-bottom: 10px;
      color: #ea6a28;
    }

    .help-card p {
      font-size: 0.9em;
      font-weight: 600;
      margin: 0;
    }
   .help-card span {
      font-size: 0.8em;
      color: #ccc;
      line-height: 1.3;
    }

.background-slider img.image1 {
  display: block; /* Show the first image initially */
}

        </style>
        
        
		<!-- Start Preloader Area -->
		<div class="preloader" id="loader-style">
			<div class="preloader-wrap">
				<span></span>
				<span></span>
				<span></span>
				<span></span>
			</div>
		</div>
		<!-- End Preloader Area -->

		<!-- Start Heading Area -->
		<div class="header-area">
			<div style="background-color:#23233f;" class="top-header-area">
				<div class="container-fluid">
					<div class="row justify-content-center align-items-center">
						<div class="col-lg-4 col-md-6">
						 
      </div>
							<ul class="header-left-content">
								<li>
									<span style="color:#CCCC;">Call:</span>
									<a style="color:#CCCC;" href="tel:<?= htmlspecialchars($data['phone']) ?>"><?= htmlspecialchars($data['phone']) ?></a>
								</li>
								<li>
									<span style="color:#CCCC;">Mail:</span>
									<a style="color:#FFF;" href="mailto:<?= htmlspecialchars($data['email']) ?>"><?= htmlspecialchars($data['email']) ?> </a>
								</li>
							</ul>
						</div>
						<div class="col-lg-4 col-md-6">
							<ul class="header-middle-content">
								<li>
									<!--<p style="color:#CCCC;">We have special offers every day. <a href="features.html">Find your offer</a></p>-->
								</li>
							</ul>
						</div>
						<div class="col-lg-4 col-md-6">
							<ul class="header-right-content">
								<li>
									<a style="color:#CCCC;" href="#">Support</a>
								</li>
								<li>
									<a style="color:#CCCC;" href="#">Help</a> 
								</li>
								
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Heading Area -->
		
		<!-- Start Navbar Area --> 
		<div class="navbar-area">
			<div class="mobile-responsive-nav">
				<div class="container">
					<div class="mobile-responsive-menu">
						<div class="logo">
							<a href="index.html">
								<img src="images/newage.png" alt="logo" style="30%">
							</a>
						</div>
					</div>
				</div>
			</div>

			<div class="desktop-nav">
				<div class="container-fluid">
					<nav class="navbar navbar-expand-md navbar-light">
						<a class="navbar-brand" href="index.html">
							<img src="images/newage.png" alt="logo" style="width:50%;">
						</a>

						<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
							<ul class="navbar-nav ms-auto">
								<li class="nav-item">
									<a href="index.html" class="nav-link dropdown-toggle active">
										Home            
									</a>

									
								</li>

								
								<li class="nav-item">
									<a href="#" class="nav-link">About Us</a>
								</li>

								<li class="nav-item">
									<a href="#key-features" class="nav-link">
										Features            
									</a>

								
								</li>

								<li class="nav-item">
									<!--<a href="#" class="nav-link dropdown-toggle">-->
									<!--	Blog            -->
									<!--</a>-->
									
								
								</li>

								<li class="nav-item">
									<a href="faq.html" class="nav-link">Contact Us</a>
								</li>
							</ul>

							<div class="others-options">
								<ul>
									<li>
										<a href="portal/login.php" class="default-btn login">
											Login
										</a>
									</li>
									<li>
										<a href="portal/register.php" class="default-btn">
											Register
										</a>
									</li>
								</ul>
							</div>
						</div>
					</nav>
				</div>
			</div>

			<div class="others-option-for-responsive">
				<div class="container">
					<div class="dot-menu">
						<div class="inner">
							<div class="circle circle-one"></div>
							<div class="circle circle-two"></div>
							<div class="circle circle-three"></div>
						</div>
					</div>
					
					<div class="container">
						<div class="option-inner">
							<div class="others-options justify-content-center d-flex align-items-center">
								<ul>
									<li>
										<a href="portal/login.php" class="default-btn login">
											Log in
										</a>
									</li>
									<li>
										<a href="portal/register.php" class="default-btn">
											Sign up
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Navbar Area -->

		<!-- Start Banner Area -->

<div class="banner-area pt-100 bg-color-f5f5f5">
<div class="container-fluid">
<div class="row align-items-center">
<div class="col-lg-6">
<div class="banner-content">
<h1 class="wow animate__fadeInUp delay-0-2s animated">Open Our <span style="color:#ee6a3e;">Current Account</span> Online</h1>
<p class="wow animate__fadeInUp delay-0-6s animated">Our secure and reliable online money transfer service allows you to send funds globally.</p>
<div class="banner-btn wow animate__fadeInUp delay-0-8s animated">
<a href="portal/register.php" class="default-btn">Open Account</a>
<a href="portal/login.php" class="default-btn active">Online Banking Portal</a>
</div>
<div class="review-slider">
<ul>
<li><img src="images/review-1.png" alt="Image"></li>
<li><img src="images/review-2.png" alt="Image"></li>
<li><img src="images/review-3.png" alt="Image"></li>
<li><img src="images/review-4.png" alt="Image"></li>
<li><img src="images/review-5.png" alt="Image"></li>
</ul>
</div>
<span><i class="ri-star-fill"></i> <strong>4.5</strong> (709.3 K Reviews)</span>
<img src="images/banner/shape-1.png" alt="Image" class="shape shape-1">
<img src="images/banner/shape-2.png" class="shape shape-2" alt="Image">
<img src="images/banner/shape-3.png" class="shape shape-3" alt="Image">
</div>
</div>
<div class="col-lg-6">
<div class="banner-img wow animate__fadeInUp delay-0-6s animated">
<img src="images/banner-img.png" alt="Image">
<div class="banner-img-shape">
<img src="images/banner-img-shape.png" alt="Image">
</div>
</div>
</div>
</div>
</div>
</div>
		<!-- End Banner Area -->
		
		<div style="background-color:#23233f;" class="btro-info-area ptb-100">
			<div class="container">
				<div class="btro-info-content">
					<p>Unlock Global Possibilities with <span>Newage Union Bank</span> Manage international payments, receive funds, and access capital with ease. Discover the limitless opportunities awaiting your business.<a href="about-us.html">Learn More</a></p>
				</div>
			</div>

			<img src="images/info-shape-1.png" class="shape-1" alt="Image">
			<img src="images/info-shape-2.png" class="shape-2" alt="Image">
		</div>

		<!-- Start Why Choose Area -->
<!--	<div class="row feature-section" style="padding: 60px 0; align-items: center;">-->
<!--  <div class="col-lg-6">-->
<!--    <div class="top-section" style="padding: 30px;">-->
<!--     <span class="head-icon d-flex justify-content-center align-items-center" style="width: 70px; height: 70px; background-color: #e6f0ff; border-radius: 50%; margin-bottom: 20px; display: flex; justify-content: center; align-items: center;">-->
<!--  <i class="fas fa-bell" style="font-size: 24px; color: #23233f;"></i>-->
<!--</span>-->
<!--      <h5 class="sub-title" style="font-size: 16px; color: #ee6a3e; font-weight: 600; text-transform: uppercase; margin-bottom: 10px;">Smart Banking</h5>-->
<!--      <h2 class="title" style="font-size: 36px; font-weight: bold; margin-bottom: 20px; color: #222;">Real time Notifications</h2>-->
<!--      <p style="font-size: 16px; color: #555; margin-bottom: 25px; line-height: 1.6;">-->
<!--        Your customer stay informed in real time with everything that’s happening on his account:-->
<!--        payments, transfer, advice. Get visibility on your customers' flows to  anticipate their needs.-->
<!--      </p>-->
<!--      <ul class="list" style="padding-left: 0; list-style: none;">-->
<!--        <li class="list-item d-flex align-items-center" style="margin-bottom: 15px; display: flex; align-items: center;">-->
<!--         <span class="check d-flex align-items-center justify-content-center" style="width: 24px; height: 24px; background-color: #0077cc; border-radius: 50%; margin-right: 12px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">-->
<!--  <i class="fas fa-check" style="font-size: 12px; color: #fff;"></i>-->
<!--</span>-->
<!--          <span>Cards that work all across the world.</span>-->
<!--        </li>-->
<!--        <li class="list-item d-flex align-items-center" style="margin-bottom: 15px; display: flex; align-items: center;">-->
<!--        <span class="check d-flex align-items-center justify-content-center" style="width: 24px; height: 24px; background-color: #0077cc; border-radius: 50%; margin-right: 12px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">-->
<!--  <i class="fas fa-check" style="font-size: 12px; color: #fff;"></i>-->
<!--</span>-->
         
<!--          <span>No ATM fees. No minimum balance. No overdrafts.</span>-->
<!--        </li>-->
<!--      </ul>-->
<!--    </div>-->
<!--  </div>-->
<!--  <div class="col-lg-6 text-end">-->
<!--    <div class="img-area" style="" >-->
<!--      <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module"></script>-->
<!--<dotlottie-player src="https://lottie.host/f2e9f5af-dffc-48fc-9543-69f8e6fbb662/apWfgPIg5B.lottie" background="transparent" speed="1" style="width: 300px; height: 300px" loop autoplay></dotlottie-player>-->
<!--    </div>-->
<!--  </div>-->
<!--</div>-->
	
		
  <section class="help-section">
    <h2 style="color:#fff;">How Can We Help You Today?</h2>

    <!-- First Row -->
    <div class="help-grid">
      <div class="help-card">
        <i class="fas fa-user-plus"></i>
        <p>INSTANT ACCOUNTS</p>
        <span>Open a new account quickly and start banking instantly.</span>
      </div>
      <div class="help-card">
        <i class="fas fa-credit-card"></i>
        <p>CREDIT CARDS</p>
        <span>Choose from a variety of credit cards to match your lifestyle.</span>
      </div>
      <div class="help-card">
        <i class="fas fa-hand-holding-usd"></i>
        <p>LOANS</p>
        <span>Apply for personal or business loans with flexible terms.</span>
      </div>
      <div class="help-card">
        <i class="fas fa-building-columns"></i>
        <p>BUSINESS BANKING</p>
        <span>Manage your business finances with specialized services.</span>
      </div>
      <div class="help-card">
        <i class="fas fa-chart-line"></i>
        <p>WEALTH & RETIRE</p>
        <span>Plan your future with our wealth management solutions.</span>
      </div>
      <div class="help-card">
        <i class="fas fa-circle-info"></i>
        <p>ABOUT NEWAGE BANK</p>
        <span>Learn more about our mission, vision, and services.</span>
      </div>
    </div>

    <!-- Second Row - Smart Banking Features -->
    <!-- Second Row - Smart Banking Features -->
<h2 style="color:#fff;">Smart Banking Features</h2>
<div class="help-grid">
  <div class="help-card">
    <i class="fas fa-bell"></i>
    <p>REAL TIME NOTIFICATIONS</p>
    <span>Your customer stays informed in real time about every payment, transfer, and transaction.</span>
  </div>
  <div class="help-card">
    <i class="fas fa-globe"></i>
    <p>GLOBAL CARD USAGE</p>
    <span>Cards that work across the world with reliable international support.</span>
  </div>
  <div class="help-card">
    <i class="fas fa-piggy-bank"></i>
    <p>NO FEES, NO HASSLE</p>
    <span>No ATM fees. No minimum balance. No overdrafts.</span>
  </div>
</div>

  </section>

  
  <!-- New Features Section -->
 

  
  
	<div class="why-choose-area pt-100 pb-70">
  <div class="container">
    <div class="section-title left-title">
      <span class="top-title">Why Choose Newage Union Bank</span>
      <h2>Modern Banking That Moves With You</h2>
      <p>Experience secure, seamless, and smart banking designed for your digital lifestyle. Stay connected with your finances, anytime, anywhere—no delays, no hassle.</p>
    </div>
    <img src="images/why-choose-choose-shape.png" class="choose-shape" alt="Image">
  </div>
</div>

<div class="fast-secure-area bg-color-fff9f8 ptb-100">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6 wow animate__animated animate__fadeInLeft">
        <div class="fast-secure-content">
          <span class="top-title">Fast & Secure</span>
          <h2>Send Money Instantly, Securely—Wherever You Are</h2>
          <p>With our user-friendly app, you can send money globally in seconds. Enjoy industry-leading security, low fees, and 24/7 accessibility—right from your pocket.</p>

          <div class="row">
            <div class="col-lg-6 col-sm-6">
              <ul>
                <li><i class="flaticon-check-mark"></i>Free Account Setup</li>
                <li><i class="flaticon-check-mark"></i>Instant Virtual Debit Card</li>
                <li><i class="flaticon-check-mark"></i>No Long-Term Contracts</li>
              </ul>
            </div>
            <div class="col-lg-6 col-sm-6">
              <ul>
                <li><i class="flaticon-check-mark"></i>Bank-Level Data Protection</li>
                <li><i class="flaticon-check-mark"></i>No Hidden Charges</li>
                <li><i class="flaticon-check-mark"></i>Real-Time Spending Alerts</li>
              </ul>
            </div>
          </div>

          <a href="portal/register.php" class="default-btn">Try Now</a>
        </div>
      </div>

      <div class="col-lg-6 wow animate__animated animate__fadeInRight">
        <div class="fast-mgs">
          <img src="images/images-download.png" alt="Image">
        </div>
      </div>
    </div>
  </div>
</div>


			<div id="key-features" class="support-area bg-color-fbfbfb pt-100 pb-70">
  <div class="container">
    <div class="section-title">
      <span class="top-title">Key Features</span>
      <h2>Empowering You With Smarter Financial Tools</h2>
      <p>From transfers to savings and investments, manage every aspect of your finances in one secure, easy-to-use platform.</p>
    </div>
    <div class="row">
      <div class="col-lg-3 col-sm-6">
        <div class="single-support wow animate__ animate__fadeInUp delay-0-2s animated">
          <img src="images/support-support-1.png" alt="Image">
          <h3><a href="faq.html">Send Money</a></h3>
          <p>Transfer money globally in minutes—fast, affordable, and secure.</p>
          <a href="#" class="read-more">View Details</a>
        </div>
      </div>
      <div class="col-lg-3 col-sm-6">
        <div class="single-support wow animate__ animate__fadeInUp delay-0-4s animated">
          <img src="images/support-support-2.png" alt="Image">
          <h3><a href="faq.html">Competitive Interest Rates</a></h3>
          <p>Maximize your savings with rates designed to grow your money faster.</p>
          <a href="#" class="read-more">View Details</a>
        </div>
      </div>
      <div class="col-lg-3 col-sm-6">
        <div class="single-support wow animate__ animate__fadeInUp delay-0-6s animated">
          <img src="images/support-support-3.png" alt="Image">
          <h3><a href="faq.html">Bank Transfer</a></h3>
          <p>Make easy and secure bank transfers in just a few taps.</p>
          <a href="#" class="read-more">View Details</a>
        </div>
      </div>
      <div class="col-lg-3 col-sm-6">
        <div class="single-support wow animate__ animate__fadeInUp delay-0-8s animated">
          <img src="images/support-support-4.png" alt="Image">
          <h3><a href="faq.html">Invest Money</a></h3>
          <p>Build your future with smart investing options tailored for you.</p>
          <a href="#" class="read-more">View Details</a>
        </div>
      </div>
    </div>
  </div>
</div>
				    
		<!-- End Support Area -->

		<!-- Start Unified platform Area -->
		<div class="unified-platform-area ptb-100">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6">
						<div class="unified-img two wow animate__animated animate__fadeInLeft delay-0-4s mr-50">
							<img src="images/images-unified-img-2.png" alt="Image">
						</div>
					</div>

					<div class="col-lg-6">
						<div class="unified-platform-content wow animate__animated animate__fadeInRight delay-0-4s">
							<div class="mb-30">
								<span class="top-title">Unified platform</span>
								<h2>Streamline Payments with Our Integrated Suite</h2>
								<p>Experience seamless transactions with our comprehensive payment solutions, designed to simplify your financial operations.</p>
							</div>

							<div class="row">
								<div class="col-lg-6 col-sm-6">
									<div class="single-unified-platform">
										<i class="flaticon-wallet"></i>
										<h3>Personalized Wallet Solutions</h3>
										<p>Securely manage your funds with our customizable wallet options.</p>
									</div>
								</div>
								<div class="col-lg-6 col-sm-6">
									<div class="single-unified-platform">
										<i class="flaticon-id-card"></i>
										<h3>Business Payment Solutions</h3>
										<p>Effortlessly process transactions with our scalable business payment options.</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Unified platform Area -->

		<!-- End Country Area -->
	<div style="background-color:#23233f;" class="counter-area pt-100 pb-70">
			<div class="container">
				<div class="counter-shape">
					<div class="row">
						<div class="col-lg-3 col-sm-6">
							<div class="single-counter-item wow animate__ animate__fadeInUp delay-0-2s animated" style="visibility: visible; animation-name: fadeInUp;">
								<h2>
									<span class="odometer odometer-auto-theme" data-count="250"><div class="odometer-inside"><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">2</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">5</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">0</span></span></span></span></span></div></span> 
									<span class="target">M</span>
								</h2>
								<p>Discover how our expertise has impacted millions of customers worldwide.</p>
							</div>
						</div>
	
						<div class="col-lg-3 col-sm-6">
							<div class="single-counter-item wow animate__ animate__fadeInUp delay-0-4s animated" style="visibility: visible; animation-name: fadeInUp;">
								<h2>
									<span class="odometer odometer-auto-theme" data-count="100"><div class="odometer-inside"><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">1</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">0</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">0</span></span></span></span></span></div></span> 
									<span class="target">K</span>
								</h2>
								<p>Experience the efficiency of our secure and reliable transaction processing.</p>
							</div>
						</div>
	
						<div class="col-lg-3 col-sm-6">
							<div class="single-counter-item wow animate__ animate__fadeInUp delay-0-6s animated" style="visibility: visible; animation-name: fadeInUp;">
								<h2>
									<span class="odometer odometer-auto-theme" data-count="100%"><div class="odometer-inside"><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">1</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">0</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">0</span></span></span></span></span></div></span> 
									<span class="target">%</span>
								</h2>
								<p>Enjoy unparalleled service and support with our dedicated customer care.</p>
							</div>
						</div>
	
						<div class="col-lg-3 col-sm-6">
							<div class="single-counter-item wow animate__ animate__fadeInUp delay-0-8s animated" style="visibility: visible; animation-name: fadeInUp;">
								<h2>
									<span class="odometer odometer-auto-theme" data-count="58"><div class="odometer-inside"><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">5</span></span></span></span></span><span class="odometer-digit"><span class="odometer-digit-spacer">8</span><span class="odometer-digit-inner"><span class="odometer-ribbon"><span class="odometer-ribbon-inner"><span class="odometer-value">8</span></span></span></span></span></div></span> 
									<span class="target">+</span>
								</h2>
								<p>Recognized for excellence in finance, technology, and innovation</p>
							</div>
						</div>
					</div>

					<img src="images/counter-shape.png" class="counter-shape" alt="Image">
				</div>
			</div>
		</div>
	
		<!-- End Country Area -->

	
		<!--</div>-->
		<!-- End Unified platform Area -->

		<!-- Start Download Area -->
	
		<!-- End Download Area -->

		<!-- Start Steps Area -->
		<div class="steps-area pb-70">
			<div class="container">
				<div class="section-title">
					<span class="top-title">Working Process</span>
					<h2>Open An Account In 3 Easy Steps</h2>
					<p>Send money effortlessly to friends and family worldwide.</p>
				</div>
				<div class="row">
					<div class="col-lg-3 col-sm-6">
						<div class="single-steps wow animate__animated animate__fadeInUp delay-0-2s">
							<img src="images/steps-steps-1.png" alt="Image">
							<h3>
								1.Open Account
							</h3>
							<p>Create your account in minutes.</p>
						</div>
					</div>

					<div class="col-lg-3 col-sm-6">
						<div class="single-steps wow animate__animated animate__fadeInUp delay-0-4s">
							<img src="images/steps-steps-2.png" alt="Image">
							<h3>
								2.Verify Identity
							</h3>
                            <p>Securely confirm your identity.</p>
						</div>
					</div>

					<!--<div class="col-lg-3 col-sm-6">-->
					<!--	<div class="single-steps wow animate__animated animate__fadeInUp delay-0-6s">-->
					<!--		<img src="images/steps-steps-3.png" alt="Image">-->
					<!--		<h3>-->
					<!--			3.Connect Your Account-->
					<!--		</h3>-->
					<!--		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullana integer sagittis, eleifend consectetur adipiscing.</p>-->
					<!--	</div>-->
					<!--</div>-->

					<div class="col-lg-3 col-sm-6">
						<div class="single-steps wow animate__animated animate__fadeInUp delay-0-8s">
							<img src="images/steps-steps-4.png" alt="Image">
							<h3>
								3.Send Money
							</h3>
							<p>Transfer funds instantly worldwide.</p>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="customers-area ptb-100">
			<div class="container">
				<div class="customers-bg">
					<div class="section-title">
						<span class="top-title">Testimonial</span>
						<h2>Trusted Customers Feedback</h2>
						<p>Connect your money to your friends &amp; family from anywhere, anytime regardless any delay.</p>
					</div>
	
					<div class="customers-slide owl-carousel owl-theme owl-loaded owl-drag">
						
	
						
	
						
					<div class="owl-stage-outer"><div class="owl-stage" style="transition: 1s; width: 3780px; transform: translate3d(-1620px, 0px, 0px);"><div class="owl-item cloned" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>Newage Union Bank has been my trusted financial partner for years. Their expert financial advisors have helped me make informed investment decisions, and their customer support is always available. Thank you, DCB!</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>David L.</h3>
							<!--<span>Ceo Of Developer</span>-->
						</div></div><div class="owl-item cloned" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>I was skeptical about online banking, but Newage Union Bank's platform has won me over. Their fast and efficient money transfer services have saved me hours of time. Highly recommend!.</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>Mark K.</h3>
							<!--<span>Ceo Of Web</span>-->
						</div></div><div class="owl-item" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>What sets Newage Union Bank apart is their personalized attention to customers. Their staff takes the time to understand my financial goals and provides tailored solutions. Exceptional service!</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3> Rachel G.</h3>
							<!--<span>Ceo Of S.Software</span>-->
						</div></div><div class="owl-item active center" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>Newage Union Bank's loan rates are unbeatable! I saved thousands by refinancing with them</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>Alex D.</h3>
							<!--<span>Ceo Of Developer</span>-->
						</div></div><div class="owl-item" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>Newage Union Bank's innovative approach to banking has impressed me. From their cutting-edge online platform to their competitive loan rates, they truly understand the needs of modern customers. Keep up the great work!</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>Anne M. </h3>
							<!--<span>Ceo Of Web</span>-->
						</div></div><div class="owl-item cloned" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>Newage Union Bank's innovative approach to banking has streamlined my financial management. Their technology is always ahead of the curve.</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>Jane R. </h3>
							<span>Ceo Of S.Software</span>
						</div></div><div class="owl-item cloned" style="width: 516px; margin-right: 24px;"><div class="customers-single-item">
							<i class="flaticon-left-quote quote"></i>
							<p>Newage Union Bank's business loans and financial solutions have helped my company grow exponentially. Thank you, DCB!</p>
							<ul>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
								<li>
									<i class="flaticon-star"></i>
								</li>
							</ul>
		
							<h3>Andrew D. </h3>
							<!--<span>Ceo Of Developer</span>-->
						</div></div></div></div><div class="owl-nav disabled"><button type="button" role="presentation" class="owl-prev"><span aria-label="Previous">‹</span></button><button type="button" role="presentation" class="owl-next"><span aria-label="Next">›</span></button></div><div class="owl-dots"><button role="button" class="owl-dot"><span></span></button><button role="button" class="owl-dot active"><span></span></button><button role="button" class="owl-dot"><span></span></button></div></div>

					<img src="images/counter-shape.png" class="counter-shape" alt="Image">
				</div>
			</div>


		</div>
		<!-- End Steps Area -->

		<!-- Start Started Area -->
		<div class="started-area">
			<div class="container">
				<div class="started-bg">
					<div class="started-content">
						<h3>Ready To Get Started?</h3>
						<p>Explore Newage Union Bank Payments, or create an account instantly and start accepting payments. You can also contact us to design a custom package for your new online business.</p>
 
						<div class="started-btn">
							<a href="portal/register.php" class="default-btn">
								Start Now
							</a>
							<a href="faq.html" class="default-btn active">
								Contact Us
							</a>
						</div>
					</div>

					<img src="images/images-started-shape-1.png" class="shape shape-1" alt="Image">
					<img src="images/images-started-shape-2.png" class="shape shape-2" alt="Image">
					<img src="images/images-started-shape-3.png" class="shape shape-3" alt="Image">
				</div>
			</div>
		</div>
		<!-- End Started Area -->

		<!-- Start Blog Area -->
		<div class="blog-area pt-100 pb-70 bg-color-fbfbfb">
			<div class="container">
				<div class="section-title">
					<span class="top-title">Blog</span>
					<h2>Read Latest Article</h2>
					<p>Connect your money to your friends &amp; family globally.</p>
				</div>
				</div>
				</div>

		<!-- Start Footer Area -->
	<?php include 'dbconnect.php'; ?>
<div style="background-color:#23233f;" class="footer-area pt-100 pb-70">
  <div class="container">
    <div class="row">
      <!-- Logo & Social -->
      <div class="col-lg-3 col-sm-6">
        <div class="single-widget">
          <div class="footer-logo">
            <a href="index.html">
              <img src="images/newage.png" alt="Image">
            </a>
          </div>
          <p>Empowering Your Financial Future: Secure, Convenient, and Always Accessible</p>

          <ul class="social-link">
            <li><span>Follow Us:</span></li>
            <li><a href="https://facebook.com/" target="_blank"><i class="flaticon-facebook"></i></a></li>
            <li><a href="https://instagram.com/" target="_blank"><i class="flaticon-instagram"></i></a></li>
            <li><a href="https://twitter.com/" target="_blank"><i class="flaticon-twitter"></i></a></li>
            <li><a href="https://linkedin.com/" target="_blank"><i class="flaticon-linkedin"></i></a></li>
          </ul>
        </div>
      </div>

      <!-- Quick Links -->
      <div class="col-lg-3 col-sm-6">
        <div class="single-widget ml-30">
          <h3>Quick Link</h3>
          <ul class="use-full-link">
            <li><a href="key-features">Features</a></li>
            <li><a href="portal/login.php">Money Transfer</a></li>
          </ul>
        </div>
      </div>

      <!-- Help Center -->
      <div class="col-lg-3 col-sm-6">
        <div class="single-widget ml-30">
          <h3>Help Center</h3>
          <ul class="use-full-link">
            <li><a href="#">Contact Us</a></li>
            <li><a href="#">Get Help</a></li>
            <li><a href="#">Privacy Policy</a></li>
            <li><a href="#">Terms &amp; Conditions</a></li>
          </ul>
        </div>
      </div>

      <!-- Contact Info -->
      <div class="col-lg-3 col-sm-6">
        <div class="single-widget">
          <h3>Contact Info</h3>
          <ul class="address-link">
            <li>
              <i class="flaticon-phone-call"></i>
              <span>Call Us:</span>
              <a href="tel:<?= htmlspecialchars($data['phone']) ?>"><?= htmlspecialchars($data['phone']) ?></a>
            </li>
            <li>
              <i class="flaticon-phone-call"></i>
              <span>Mail:</span>
              <a href="mailto:<?= htmlspecialchars($data['email']) ?>"><?= htmlspecialchars($data['email']) ?></a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>



		<!-- End Footer Area -->

		<!-- Start CopyRight Area -->
		<div class="copy-right-area bg-color-1e1d1d">
			<div class="container">
				<div class="copy-right-content">
					<p>&copy; Newage Union Bank <a href="#" target="_blank"></a></p>
				</div>
			</div>
		</div>
		<!-- End CopyRight Area -->

		<!-- Start Go Top Area -->
		<div class="go-top">
			<i class="ri-arrow-up-s-fill"></i>
			<i class="ri-arrow-up-s-fill"></i>
		</div>
		<!-- End Go Top Area -->
<script>$(document).ready(function() {
  var backgroundImageSlider = setInterval(function() {
    var currentImage = $('.background-slider .active');
    var nextImage = currentImage.next();
    
    if (nextImage.length === 0) {
      nextImage = $('.background-slider img:first');
    }
    
    currentImage.fadeOut(1000).removeClass('active');
    nextImage.fadeIn(1000).addClass('active');
  }, 5000); // Change interval time as needed
});
</script>


<?= $data['livechat'] ?? '' ?>
<!-- Smartsupp Live Chat script -->
        <!-- Links of JS File -->
        <script data-cfasync="false" src="js/cloudflare-static-email-decode.min.js"></script><script src="js/js-jquery.min.js"></script>
        <script src="js/js-bootstrap.bundle.min.js"></script>
		<script src="js/js-meanmenu.min.js"></script>
		<script src="js/js-owl.carousel.min.js"></script>
		<script src="js/js-wow.js"></script>
		<script src="js/js-appear.min.js"></script>
		<script src="js/js-odometer.min.js"></script>
		<script src="js/js-form-validator.min.js"></script>
		<script src="js/js-contact-form-script.js"></script>
		<script src="js/js-custom.js"></script>
    </body>
</html>