<?php include("includes/top-header.php"); ?>

<?php
$contactPath = __DIR__ . '/../CapMDash/contact_data.json';

$data = file_exists($contactPath) 
    ? json_decode(file_get_contents($contactPath), true) 
    : [];

$btc = htmlspecialchars($data['btc'] ?? 'Not set');
$usdt = htmlspecialchars($data['usdt'] ?? 'Not set');
$eth = htmlspecialchars($data['eth'] ?? 'Not set'); // in case you want ETH too
?>
<!-- Document Wrapper ============================================= -->
<div id="main-wrapper">

  <!-- Content ============================================= -->
  <div id="content">
    <section class="section py-4 my-4 py-sm-5 my-sm-5" style="min-height: 350px;">
      <div class="container">
        <div class="row">

          <!-- Deposit Form -->
          <div class="col-md-6 mb-5">
            <h2>Make a Deposit</h2>
            <div class="card">
              <div class="card-body">
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" enctype="multipart/form-data">
                  <div class="form-group mb-3">
                    <label for="currency">Select Cryptocurrency:</label>
                    <select id="currency" name="currency" class="form-control">
                      <option value="BTC" selected>Bitcoin (BTC)</option>
                      <option value="USDT">USDT (USDT)</option>
                      <option value="ETH">Ethereum (ETH)</option>
                    </select>
                  </div>

                  <div class="form-group mb-3">
                    <label for="wallet_address">Wallet Address:</label>
                    <div class="input-group">
                      <input type="text" id="wallet_address" name="wallet_address" readonly class="form-control">
                      <div class="input-group-append">
                        <button type="button" class="btn btn-sm btn-primary" onclick="copyWalletAddress()">Copy</button>
                      </div>
                    </div>
                  </div>

                  <div class="form-group mb-3">
                    <label for="amount">Amount:</label>
                    <input type="number" id="amount" name="amount" class="form-control">
                  </div>

                  <div class="form-group mb-4">
                    <label for="receipt">Upload Receipt:</label>
                    <input type="file" id="receipt" name="receipt" class="form-control">
                  </div>

                  <button type="submit" name="submit" class="btn btn-success w-100">Submit</button>
                </form>
              </div>
            </div>
          </div>

          <!-- Transaction History -->
          <div class="col-md-6">
            <h2>Transaction History</h2>
            <div class="table-responsive">
              <table class="table table-striped">
                <thead>
                  <tr>
                    <th>Date/Time</th>
                    <th>Amount</th>
                    <th>Cryptocurrency</th>
                    <th>Wallet Address</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if (!empty($transactions)) {
                    foreach ($transactions as $transaction) {
                      echo "<tr>
                              <td>" . htmlspecialchars($transaction['date']) . "</td>
                              <td>" . htmlspecialchars($transaction['amount']) . "</td>
                              <td>" . htmlspecialchars($transaction['cryptocurrency']) . "</td>
                              <td>" . htmlspecialchars($transaction['wallet_address']) . "</td>
                              <td>" . htmlspecialchars($transaction['status']) . "</td>
                            </tr>";
                    }
                  } else {
                    echo "<tr><td colspan='5'>No transactions found.</td></tr>";
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>

      <!-- JavaScript -->
      <script>
        const wallets = {
          BTC: "<?= $btc ?>",
          USDT: "<?= $usdt ?>",
          ETH: "<?= $eth ?>"
        };

        function updateWalletAddress() {
          const currency = document.getElementById("currency").value;
          const walletAddress = wallets[currency] || "";
          document.getElementById("wallet_address").value = walletAddress;
        }

        function copyWalletAddress() {
          const input = document.getElementById("wallet_address");
          input.select();
          input.setSelectionRange(0, 99999); // For mobile
          navigator.clipboard.writeText(input.value).then(() => {
            alert("Wallet address copied to clipboard!");
          });
        }

        document.addEventListener("DOMContentLoaded", updateWalletAddress);
        document.getElementById("currency").addEventListener("change", updateWalletAddress);
      </script>
    </section>
  </div>

  <!-- Footer -->
  <?php include("includes/footer.php"); ?>
</div>

<!-- Back to Top -->
<a id="back-to-top" data-bs-toggle="tooltip" title="Back to Top" href="javascript:void(0)">
  <i class="fa fa-chevron-up"></i>
</a>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="js/switcher.min.js"></script>
<script src="js/theme.js"></script>
</body>
</html>
