<?php
session_start();
include("includes/top-header.php");

// Activate correct menu link
$link_status4 = "active";
$link_status5 = "";
$link_status6 = "";

// Database connection assumed in includes
$uid = $_SESSION['uid']; // Make sure the user is logged in
$allowedTypes = ['image/jpeg', 'image/png'];
$maxSize = 2 * 1024 * 1024; // 2MB max
$uploadDir = 'uploads/kyc/';

// Ensure directory exists
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (isset($_FILES['id_front']) && isset($_FILES['id_back'])) {
        $front = $_FILES['id_front'];
        $back = $_FILES['id_back'];

        if (!in_array($front['type'], $allowedTypes) || !in_array($back['type'], $allowedTypes)) {
            $error_message = "Only JPEG and PNG files are allowed.";
        } elseif ($front['size'] > $maxSize || $back['size'] > $maxSize) {
            $error_message = "Each file must be less than 2MB.";
        } else {
            $timestamp = time();
            $front_filename = $uid . "_front_" . $timestamp . "." . pathinfo($front['name'], PATHINFO_EXTENSION);
            $back_filename = $uid . "_back_" . $timestamp . "." . pathinfo($back['name'], PATHINFO_EXTENSION);

            $front_path = $uploadDir . $front_filename;
            $back_path = $uploadDir . $back_filename;

            if (move_uploaded_file($front['tmp_name'], $front_path) && move_uploaded_file($back['tmp_name'], $back_path)) {
                // Save to DB
                $stmt = $conn->prepare("UPDATE users SET kyc_front = ?, kyc_back = ?, kyc_status = 'Pending' WHERE uID = ?");
                $stmt->bind_param("ssi", $front_path, $back_path, $uid);

                if ($stmt->execute()) {
                    $success_message = "KYC documents uploaded successfully. Verification is pending.";
                    $front_file = $front_path;
                    $back_file = $back_path;
                } else {
                    $error_message = "Database error: " . $stmt->error;
                }

                $stmt->close();
            } else {
                $error_message = "Failed to upload files. Please try again.";
            }
        }
    } else {
        $error_message = "Both ID front and back images are required.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>KYC Verification</title>
  <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
  <style>
    body {
        background-color: #f4f7fa;
    }
    .upload-section {
        border: 1px solid #ddd;
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        background-color: #ffffff;
        margin-top: 60px;
    }
    .upload-section h3 {
        color: #333;
        font-size: 24px;
        margin-bottom: 20px;
        text-align: center;
    }
    .form-label {
        font-weight: bold;
    }
    .form-control {
        border-radius: 10px;
        padding: 10px;
    }
    .btn-primary {
        background-color: #007bff;
        border-color: #007bff;
        color: white;
        border-radius: 10px;
        padding: 12px;
        width: 100%;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
    .alert {
        margin-top: 20px;
    }
    .file-preview {
        display: flex;
        gap: 20px;
        margin-top: 20px;
        justify-content: center;
    }
    .file-preview img {
        max-width: 100%;
        max-height: 250px;
        object-fit: contain;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .preview-header {
        font-size: 1.1rem;
        font-weight: bold;
        text-align: center;
        margin-top: 10px;
    }
    .help-text {
        font-size: 12px;
        color: #6c757d;
        text-align: center;
        margin-top: 10px;
    }
  </style>
</head>
<body>

<div class="container">
  <div class="row">
    <div class="col-md-8 mx-auto">
      <div class="upload-section">

        <h3>Upload Your KYC Documents</h3>

        <!-- Lottie Animation -->
        <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module"></script>
        <dotlottie-player src="https://lottie.host/ec4dfb9d-d880-4ae4-8e77-b3493ed7b96b/3T1lPNdhbV.lottie"
                          background="transparent"
                          speed="1"
                          style="width: 250px; height: 250px; margin: 0 auto; display: block;"
                          loop autoplay></dotlottie-player>

        <?php if (isset($success_message)): ?>
          <div class="alert alert-success"><?php echo $success_message; ?></div>
        <?php elseif (isset($error_message)): ?>
          <div class="alert alert-danger"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data">
          <div class="mb-3">
            <label for="idFront" class="form-label">Front Side of ID</label>
            <input type="file" class="form-control" name="id_front" id="idFront" accept="image/*" required>
            <div class="help-text">JPEG or PNG only. Max size: 2MB</div>
          </div>

          <div class="mb-3">
            <label for="idBack" class="form-label">Back Side of ID</label>
            <input type="file" class="form-control" name="id_back" id="idBack" accept="image/*" required>
            <div class="help-text">JPEG or PNG only. Max size: 2MB</div>
          </div>

          <button type="submit" class="btn btn-primary">Submit for Verification</button>
        </form>

        <!-- Preview Section -->
        <?php if (isset($front_file) || isset($back_file)): ?>
          <div class="file-preview mt-4">
            <?php if (isset($front_file)): ?>
              <div>
                <div class="preview-header">Front ID</div>
                <img src="<?php echo $front_file; ?>" alt="Front ID">
              </div>
            <?php endif; ?>
            <?php if (isset($back_file)): ?>
              <div>
                <div class="preview-header">Back ID</div>
                <img src="<?php echo $back_file; ?>" alt="Back ID">
              </div>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <div class="help-text mt-4">
          Your documents will be securely verified. Please contact support if you experience any issues.
        </div>

      </div>
    </div>
  </div>
</div>

<?php include("includes/footer.php"); ?>

<!-- Back to Top -->
<a id="back-to-top" href="javascript:void(0)" class="btn btn-primary" style="position: fixed; bottom: 20px; right: 20px;">
  <i class="fa fa-chevron-up"></i>
</a>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
