<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">
<link href="images/favicon.png" rel="icon" />
<title>User Dashboard - Guardian Trust - United</title>

<meta name="author" content="">

<!-- Web Fonts
============================================= -->
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap">

<!-- Stylesheet
============================================= -->
<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/bootstrap.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/font-awesome/css/all.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/owl.carousel/assets/owl.carousel.min.css" />
<link rel="stylesheet" type="text/css" href="css/stylesheet.css" />
<!-- Colors Css -->
<link id="color-switcher" type="text/css" rel="stylesheet" href="#" />
</head>
<body>

<!-- Preloader -->
<div id="preloader">
  <div data-loader="dual-ring"></div>
</div>
<!-- Preloader End --> 

<!-- Document Wrapper   
============================================= -->
<div id="main-wrapper"> 
  
  <!-- Header
  ============================================= -->
  <header id="header">
    <div class="container">
      <div class="header-row">
        <div class="header-column justify-content-start"> 
          <!-- Logo
          ============================= -->
          <div class="logo me-3"> <a class="d-flex" href="index.php" title="Guardian Trust - United"><img src="images/prime-1.png" alt="Guardian Trust - United" /></a> </div>
          <!-- Logo end --> 
          <!-- Collapse Button
          ============================== -->
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#header-nav"> <span></span> <span></span> <span></span> </button>
          <!-- Collapse Button end --> 
          
          <!-- Primary Navigation
          ============================== -->
          <nav class="primary-menu navbar navbar-expand-lg">
            <div id="header-nav" class="collapse navbar-collapse">
              <ul class="navbar-nav me-auto">
                <li><a href="landing-page-send.html">Send</a></li>
                <li><a href="landing-page-receive.html">Receive</a></li>
                <li><a href="about-us.html">About Us</a></li>
                <li><a href="fees.html">Fees</a></li>
                <li><a href="help.html">Help</a></li>
                <li class="dropdown"> <a class="dropdown-toggle" href="#">Features</a>
                  <ul class="dropdown-menu">
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Headers</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version (Default)</a></li>
                        <li><a class="dropdown-item" href="feature-header-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-header-primary.html">Primary Version</a></li>
                        <li><a class="dropdown-item" href="index-2.html">Transparent Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Navigation DropDown</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version (Default)</a></li>
                        <li><a class="dropdown-item" href="feature-navigation-dropdown-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-navigation-dropdown-primary.html">Primary Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Second Navigation</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="send-money.php">Default Version</a></li>
                        <li><a class="dropdown-item" href="deposit-money.html">Alternate Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Page Headers</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="feature-page-header-left-alignment.html">Left Alignment</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-center-alignment.html">Center Alignment</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-light.html">Light Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-primary.html">Primary Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-custom-background.html">Custom Background</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-custom-background-with-transparent-header.html">Custom Background 2</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Footer</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version Default</a></li>
                        <li><a class="dropdown-item" href="index-2.html">Alternate Version</a></li>
                        <li><a class="dropdown-item" href="feature-footer-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-footer-primary.html">Primary Version</a></li>
                      </ul>
                    </li>
                    <li><a class="dropdown-item" href="feature-layout-boxed.html">Layout Boxed</a></li>
                  </ul>
                </li>
                <li class="dropdown dropdown-mega"> <a class="dropdown-toggle" href="#">Pages</a>
                  <ul class="dropdown-menu">
                    <li>
                      <div class="dropdown-mega-content">
                        <div class="row">
                          <div class="col-lg"> <span class="sub-title">Homepage</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="index.php">Home Version 1</a></li>
                              <li><a class="dropdown-item" href="index-2.html">Home Version 2</a></li>
                              <li><a class="dropdown-item" href="landing-page-send.html">Landing Page - Send</a></li>
                              <li><a class="dropdown-item" href="landing-page-receive.html">Landing Page - Receive</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Account</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="settings-profile.php">My Profile</a></li>
                              <li><a class="dropdown-item" href="settings-security.php">Security</a></li>
                              <li><a class="dropdown-item" href="settings-payment-methods.php">Payment Methods</a></li>
                              <li><a class="dropdown-item" href="settings-notifications.php">Notifications</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Login</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="login.php">Login Page 1</a></li>
                                  <li><a class="dropdown-item" href="login-2.html">Login Page 2</a></li>
                                  <li><a class="dropdown-item" href="login-3.html">Login Page 3</a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Signup</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="signup.php">Signup Page 1</a></li>
                                  <li><a class="dropdown-item" href="signup-2.html">Signup Page 2 </a></li>
                                  <li><a class="dropdown-item" href="signup-3.html">Signup Page 3 </a></li>
                                </ul>
                              </li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Dashboard</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="index.php">Dashboard</a></li>
                              <li><a class="dropdown-item" href="transactions.php">Transactions</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Send Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="send-money.php">Send Money</a></li>
                                  <li><a class="dropdown-item" href="send-money-confirm.php">Send Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="send-money-success.php">Send Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Request Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="request-money.html">Request Money</a></li>
                                  <li><a class="dropdown-item" href="request-money-confirm.html">Request Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="request-money-success.html">Request Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Deposit Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="deposit-money.html">Deposit Money</a></li>
                                  <li><a class="dropdown-item" href="deposit-money-confirm.html">Deposit Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="deposit-money-success.html">Deposit Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Withdraw Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="withdraw-money.html">Withdraw Money</a></li>
                                  <li><a class="dropdown-item" href="withdraw-money-confirm.html">Withdraw Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="withdraw-money-success.html">Withdraw Money Success </a></li>
                                </ul>
                              </li>
                              <li><a class="dropdown-item" href="notifications.php">Notifications</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Blog</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="blog.html">Blog Standard</a></li>
                              <li><a class="dropdown-item" href="blog-grid.html">Blog Grid</a></li>
                              <li><a class="dropdown-item" href="blog-list.html">Blog List</a></li>
                              <li><a class="dropdown-item" href="blog-single.html">Blog Single Right Sidebar</a></li>
                              <li><a class="dropdown-item" href="blog-single-left-sidebar.html">Blog Single Left Sidebar</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Others</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="about-us.html">About Us</a></li>
                              <li><a class="dropdown-item" href="fees.html">Fees</a></li>
                              <li><a class="dropdown-item" href="help.html">Help</a></li>
                              <li><a class="dropdown-item" href="contact-us.html">Contact Us</a></li>
                              <li><a class="dropdown-item" href="404.html">404</a></li>
                              <li><a class="dropdown-item" href="coming-soon.html" target="_blank">Coming Soon</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Elements</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="elements.html">Elements 1</a></li>
                                  <li><a class="dropdown-item" href="elements-2.html">Elements 2</a></li>
                                </ul>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                  </ul>
                </li>
              </ul>
            </div>
          </nav>
          <!-- Primary Navigation end --> 
        </div>
        <div class="header-column justify-content-end"> 
          <!-- Login & Signup Link
          ============================== -->
          <nav class="login-signup navbar navbar-expand">
            <ul class="navbar-nav">
              <li><a href="login.php">Login</a> </li>
              <li class="align-items-center h-auto ms-sm-3"><a class="btn btn-primary" href="signup.php">Sign Up</a></li>
            </ul>
          </nav>
          <!-- Login & Signup Link end --> 
        </div>
      </div>
    </div>
  </header>
  <!-- Header End --> 
  
  <!-- Page Header
    ============================================= -->
  <section class="page-header page-header-text-light bg-dark">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-8">
          <h1>Elements</h1>
        </div>
        <div class="col-md-4">
          <ul class="breadcrumb justify-content-start justify-content-md-end mb-0">
            <li><a href="index.php">Home</a></li>
            <li class="active">Elements</li>
          </ul>
        </div>
      </div>
    </div>
  </section>
  <!-- Page Header end --> 
  
  <!-- Content
  ============================================= -->
  <div id="content">
    <div class="container">
      <div class="bg-white shadow-md rounded p-4 mb-4"> 
        <!-- Featured Boxes
        ============================================= -->
        <div class="container">
          <h2 class="text-center mb-5">Featured Boxes</h2>
          <!-- Default Style
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box">
                <div class="featured-box-icon text-primary"> <i class="fas fa-thumbs-up"></i></div>
                <h3>Why choose Us</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box">
                <div class="featured-box-icon text-primary"> <i class="fas fa-paper-plane"></i> </div>
                <h3>Our Mission</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box">
                <div class="featured-box-icon text-primary"> <i class="fas fa-eye"></i> </div>
                <h3>Our Vision</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
          </div>
          <!-- Default Style end --> 
          
          <!-- Default Style Center
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box text-center">
                <div class="featured-box-icon"> <i class="fas fa-thumbs-up"></i></div>
                <h3>Why choose Us</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box text-center">
                <div class="featured-box-icon"> <i class="fas fa-paper-plane"></i> </div>
                <h3>Our Mission</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box text-center">
                <div class="featured-box-icon"> <i class="fas fa-eye"></i> </div>
                <h3>Our Vision</h3>
                <p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson squid skateboard dolor brunch.</p>
              </div>
            </div>
          </div>
          <!-- Default Style Center end --> 
          
          <!-- Style 1
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box style-1">
                <div class="featured-box-icon text-primary"> <i class="far fa-thumbs-up"></i></div>
                <h3>Why choose Us</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-1">
                <div class="featured-box-icon text-primary"> <i class="far fa-paper-plane"></i> </div>
                <h3>Our Mission</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-1">
                <div class="featured-box-icon text-primary"> <i class="far fa-eye"></i> </div>
                <h3>Our Vision</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
          </div>
          <!-- Style 1 end --> 
          
          <!-- Style 2
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box style-2">
                <div class="featured-box-icon"> <i class="fas fa-thumbs-up"></i></div>
                <h3>Why choose Us</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent iriure squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-2">
                <div class="featured-box-icon"> <i class="fas fa-paper-plane"></i> </div>
                <h3>Our Mission</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent iriure squid skateboard dolor brunch.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-2">
                <div class="featured-box-icon"> <i class="fas fa-eye"></i> </div>
                <h3>Our Vision</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent iriure squid skateboard dolor brunch.</p>
              </div>
            </div>
          </div>
          <!-- Style 2 end --> 
          
          <!-- Style 3
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon bg-light-3 text-primary rounded-circle"> <i class="fas fa-bullhorn"></i> </div>
                <h3>You Refer Friends</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon border border-primary text-primary rounded-circle"> <i class="fas fa-sign-in-alt"></i> </div>
                <h3>Your Friends Register</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon bg-primary text-white rounded-circle"> <i class="fas fa-dollar-sign"></i> </div>
                <h3>Earn You</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
          </div>
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon bg-primary text-white rounded"> <i class="fas fa-bullhorn"></i> </div>
                <h3>You Refer Friends</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon bg-dark-5 text-white rounded"> <i class="fas fa-sign-in-alt"></i> </div>
                <h3>Your Friends Register</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-3">
                <div class="featured-box-icon text-primary border border-primary rounded"> <i class="fas fa-dollar-sign"></i> </div>
                <h3>Earn You</h3>
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure.</p>
              </div>
            </div>
          </div>
          <!-- Style 3 end --> 
          
          <!-- Style 4
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-md-4">
              <div class="featured-box style-4">
                <div class="featured-box-icon bg-light-3 text-primary rounded-circle"> <i class="fas fa-bullhorn"></i> </div>
                <h3>You Refer Friends</h3>
                <p class="text-3">Share your referral link with friends. They get $10.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-4">
                <div class="featured-box-icon bg-primary text-white rounded"> <i class="fas fa-sign-in-alt"></i> </div>
                <h3>Your Friends Register</h3>
                <p class="text-3">Your friends Register with using your referral link.</p>
              </div>
            </div>
            <div class="col-md-4">
              <div class="featured-box style-4">
                <div class="featured-box-icon bg-dark text-white rounded-circle"> <i class="fas fa-dollar-sign"></i> </div>
                <h3>Earn You</h3>
                <p class="text-3">You get $20. You can use these credits to take recharge.</p>
              </div>
            </div>
          </div>
          <!-- Style 4 end --> 
          
          <!-- Style 5
          ============================================= -->
          <div class="row g-4 mb-5">
            <div class="col-sm-6 col-lg-3"> <a href="#">
              <div class="featured-box style-5 rounded">
                <div class="featured-box-icon text-primary"> <i class="fas fa-share-square"></i> </div>
                <h3>Send Money</h3>
              </div>
              </a> </div>
            <div class="col-sm-6 col-lg-3"> <a href="#">
              <div class="featured-box style-5 rounded">
                <div class="featured-box-icon text-primary"> <i class="fas fa-check-square"></i> </div>
                <h3>Receive Money</h3>
              </div>
              </a> </div>
            <div class="col-sm-6 col-lg-3"> <a href="#">
              <div class="featured-box style-5 rounded">
                <div class="featured-box-icon text-primary"> <i class="fas fa-user-friends"></i> </div>
                <h3>Pay a Friend</h3>
              </div>
              </a> </div>
            <div class="col-sm-6 col-lg-3"> <a href="#">
              <div class="featured-box style-5 rounded">
                <div class="featured-box-icon text-primary"> <i class="fas fa-shopping-bag"></i> </div>
                <h3>Online Shopping</h3>
              </div>
              </a> </div>
          </div>
          <!-- Style 5 end --> 
          
        </div>
        <!-- Featured Boxes end -->
        
        <hr>
		
		<!-- Accordion
      ============================================= -->
      <div id="accordionToggle" class="py-5">
        <h2 class="text-center mb-5">Accordion</h2>
        <div class="row">
          <div class="col-md-6"> 
            <!-- Default Style
            ============================================= -->
            <h5 class="mb-4">Default Style</h5>
            <div class="accordion" id="accordionExample">
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingOne">
      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
        How can I make a account?
      </button>
    </h2>
    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
      <div class="accordion-body">
Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet.
</div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingTwo">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        Is there any registration fee?
      </button>
    </h2>
    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
      <div class="accordion-body">
		Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet. Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Ad vegan excepteur butcher vice lomo.
	  </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
        Is my account information safe?
	  </button>
    </h2>
    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS.
      </div>
    </div>
  </div>
</div>
            <!-- Default Style end --> 
          </div>
          <div class="col-md-6"> 
            <!-- Flush Style
            ============================================= -->
            <h5 class="mb-4">Flush Style</h5>
            <div class="accordion accordion-flush" id="accordionFlushExample">
  <div class="accordion-item">
    <h2 class="accordion-header" id="flush-headingOne">
      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
        How can I make a account?
      </button>
    </h2>
    <div id="flush-collapseOne" class="accordion-collapse collapse show" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
      <div class="accordion-body">Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet.</div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="flush-headingTwo">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
        Is there any registration fee?
      </button>
    </h2>
    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
      <div class="accordion-body">Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet. Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Ad vegan excepteur butcher vice lomo.</div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="flush-headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseThree" aria-expanded="false" aria-controls="flush-collapseThree">
        Is my account information safe?
      </button>
    </h2>
    <div id="flush-collapseThree" class="accordion-collapse collapse" aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
      <div class="accordion-body">
		Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.
	  </div>
    </div>
  </div>
</div>
            <!-- Flush Style end --> 
          </div>
        </div>
         
      </div>
	  <!-- Accordion end -->
        
		<hr class="my-5">
		
        <div id="navs" class="py-5">
        <h2 class="text-center mb-5">Navs</h2>
        <div class="row">
          <div class="col-md-6">
            <h5>Basic Style</h5>
            <ul class="nav">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
          <div class="col-md-6">
            <h5>Basic Large Style</h5>
            <ul class="nav nav-lg">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Basic with Separator Style</h5>
            <ul class="nav nav-separator">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Basic Large with Separator Style</h5>
            <ul class="nav nav-separator nav-lg">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Tabs Style</h5>
            <ul class="nav nav-tabs">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Tabs Large Style</h5>
            <ul class="nav nav-tabs nav-lg">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Pills Style</h5>
            <ul class="nav nav-pills">
              <li class="nav-item"> <a class="nav-link active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
          <div class="col-md-6">
            <h5 class="mt-5 mb-4">Pills Large Style</h5>
            <ul class="nav nav-pills nav-lg">
              <li class="nav-item"> <a class="nav-link rounded-pill active" href="#">Active</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
              <li class="nav-item"> <a class="nav-link" href="#">Link</a> </li>
            </ul>
          </div>
        </div>
		
		<h5 class="mt-5 mb-4">Alternate Pills Style</h5>
		<div class="bg-primary">
    <div class="container d-flex justify-content-center">
      <ul class="nav nav-pills alternate nav-lg border-bottom-0">
        <li class="nav-item"> <a class="nav-link active" href="#">Active</a></li>
        <li class="nav-item"> <a class="nav-link" href="#">Link</a></li>
		<li class="nav-item"> <a class="nav-link" href="#">Link 2</a></li>
      </ul>
    </div>
  </div>  
		
      </div>
        
        <hr class="my-5">
        
        <!-- Tabs
        ============================================= -->
        <h2 class="text-center mb-5">Tabs</h2>
        <div class="row">
          <div class="col-md-6"> 
            <!-- Default Style
            ============================================= -->
            <h5 class="mb-4">Default Style</h5>
            <ul class="nav nav-tabs nav-lg" id="myTab" role="tablist">
  <li class="nav-item"> <a class="nav-link active" id="one-tab" data-bs-toggle="tab" href="#one" role="tab" aria-controls="one" aria-selected="true">Tab Title 1</a> </li>
  <li class="nav-item"> <a class="nav-link" id="two-tab" data-bs-toggle="tab" href="#two" role="tab" aria-controls="two" aria-selected="false">Tab Title 2</a> </li>
  <li class="nav-item"> <a class="nav-link" id="three-tab" data-bs-toggle="tab" href="#three" role="tab" aria-controls="three" aria-selected="false">Tab Title 3</a> </li>
</ul>
<div class="tab-content my-3" id="myTabContent">
  <div class="tab-pane fade show active" id="one" role="tabpanel" aria-labelledby="one-tab">
    <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet. Mediocrem qualisque in has. Enim utroque perfecto id mei, ad eam tritani labores facilisis, ullum sensibus no cum. Eius eleifend in quo. At mei alia iriure propriae.</p>
  </div>
  <div class="tab-pane fade" id="two" role="tabpanel" aria-labelledby="two-tab">
    <p>Partiendo voluptatibus ex cum, sed erat fuisset ne, cum ex meis volumus mentitum. Alienum pertinacia maiestatis ne eum, verear persequeris et vim. Mea cu dicit voluptua efficiantur, nullam labitur veritus sit cu. Eum denique omittantur te, in justo epicurei his, eu mei aeque populo.</p>
    <p>Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
  </div>
  <div class="tab-pane fade" id="three" role="tabpanel" aria-labelledby="three-tab">
    <p>Cu pro facer sententiae, ne brute graece scripta duo. No placerat quaerendum nec, pri alia ceteros adipiscing ut. Quo in nobis nostrum intellegebat. Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
  </div>
</div>

            <!-- Default Style end --> 
          </div>
          <div class="col-md-6"> 
            <!-- Pills Navigation Style
            ============================================= -->
            <h5 class="mb-4">Pills Navigation Style</h5>
            <ul class="nav nav-pills nav-lg" id="pillsmyTab" role="tablist">
              <li class="nav-item"> <a class="nav-link active" id="firstTab-Pills" data-bs-toggle="tab" href="#firstTabPills" role="tab" aria-controls="firstTabPills" aria-selected="true">Tab Title 1</a> </li>
              <li class="nav-item"> <a class="nav-link" id="secondTab-Pills" data-bs-toggle="tab" href="#secondTabPills" role="tab" aria-controls="secondTabPills" aria-selected="false">Tab Title 2</a> </li>
              <li class="nav-item"> <a class="nav-link" id="thirdTab-Pills" data-bs-toggle="tab" href="#thirdTabPills" role="tab" aria-controls="thirdTabPills" aria-selected="false">Tab Title 3</a> </li>
            </ul>
            <div class="tab-content my-3" id="pillsmyTabContent">
              <div class="tab-pane fade show active" id="firstTabPills" role="tabpanel" aria-labelledby="firstTab-Pills">
                <p>Lisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet. Mediocrem qualisque in has. Enim utroque perfecto id mei, ad eam tritani labores facilisis, ullum sensibus no cum. Eius eleifend in quo. At mei alia iriure propriae.</p>
              </div>
              <div class="tab-pane fade" id="secondTabPills" role="tabpanel" aria-labelledby="secondTab-Pills">
                <p>Partiendo voluptatibus ex cum, sed erat fuisset ne, cum ex meis volumus mentitum. Alienum pertinacia maiestatis ne eum, verear persequeris et vim. Mea cu dicit voluptua efficiantur, nullam labitur veritus sit cu. Eum denique omittantur te, in justo epicurei his, eu mei aeque populo.</p>
                <p>Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
              </div>
              <div class="tab-pane fade" id="thirdTabPills" role="tabpanel" aria-labelledby="thirdTab-Pills">
                <p>Cu pro facer sententiae, ne brute graece scripta duo. No placerat quaerendum nec, pri alia ceteros adipiscing ut. Quo in nobis nostrum intellegebat. Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
              </div>
            </div>
            <!-- Pills Navigation Style end --> 
          </div>
        </div>
        <br>
        <!-- Vertical Tabs
        ============================================= -->
        <h5 class="mb-4">Vertical Tab</h5>
        <div class="row">
          <div class="col-md-3">
            <ul class="nav nav-tabs flex-column" id="myTabVertical" role="tablist">
              <li class="nav-item"> <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#firstTab" role="tab" aria-controls="firstTab" aria-selected="true">First Title Tab</a> </li>
              <li class="nav-item"> <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#secondTab" role="tab" aria-controls="secondTab" aria-selected="false">Second Tab</a> </li>
              <li class="nav-item"> <a class="nav-link" id="third-tab" data-bs-toggle="tab" href="#thirdTab" role="tab" aria-controls="thirdTab" aria-selected="false">Third Tab</a> </li>
              <li class="nav-item"> <a class="nav-link" id="fourth-tab" data-bs-toggle="tab" href="#fourthTab" role="tab" aria-controls="fourthTab" aria-selected="false">Fourth Tab</a> </li>
            </ul>
          </div>
          <div class="col-md-9">
            <div class="tab-content my-3" id="myTabContentVertical">
              <div class="tab-pane fade show active" id="firstTab" role="tabpanel" aria-labelledby="first-tab">
                <p>Instant Online mobile recharge Iisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet. Mediocrem qualisque in has. Enim utroque perfecto id mei, ad eam tritani labores facilisis, ullum sensibus no cum. Eius eleifend in quo. At mei alia iriure propriae.</p>
                <p>Partiendo voluptatibus ex cum, sed erat fuisset ne, cum ex meis volumus mentitum. Alienum pertinacia maiestatis ne eum, verear persequeris et vim. Mea cu dicit voluptua efficiantur, nullam labitur veritus sit cu. Eum denique omittantur te, in justo epicurei his, eu mei aeque populo.</p>
              </div>
              <div class="tab-pane fade" id="secondTab" role="tabpanel" aria-labelledby="second-tab">
                <p>Partiendo voluptatibus ex cum, sed erat fuisset ne, cum ex meis volumus mentitum. Alienum pertinacia maiestatis ne eum, verear persequeris et vim. Mea cu dicit voluptua efficiantur, nullam labitur veritus sit cu. Eum denique omittantur te, in justo epicurei his, eu mei aeque populo.</p>
                <p>Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
              </div>
              <div class="tab-pane fade" id="thirdTab" role="tabpanel" aria-labelledby="third-tab">
                <p>Cu pro facer sententiae, ne brute graece scripta duo. No placerat quaerendum nec, pri alia ceteros adipiscing ut. Quo in nobis nostrum intellegebat. Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
                <p>Iisque persius interesset his et, in quot quidam persequeris vim, ad mea essent possim iriure. Mutat tacimates id sit. Ridens mediocritatem ius an, eu nec magna imperdiet.</p>
                <p>Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
              </div>
              <div class="tab-pane fade" id="fourthTab" role="tabpanel" aria-labelledby="fourth-tab">
                <p>Cu pro facer sententiae, ne brute graece scripta duo. No placerat quaerendum nec, pri alia ceteros adipiscing ut. Quo in nobis nostrum intellegebat. Ius hinc decore erroribus eu, in case prima exerci pri. Id eum prima adipisci. Ius cu minim theophrastus, legendos pertinacia an nam.</p>
              </div>
            </div>
          </div>
        </div>
        <!-- Vertical Tabs end --> 
        <br>
        <!-- Responsive Tab
        ============================================= -->
        <h5 class="mb-3">Responsive Tab</h5>
        <p class="text-info">Resize your Browser to see the Tabs change into Accordions</p>
        <div id="horizontalTab" class="resp-htabs">
          <ul class="resp-tabs-list">
            <li>Responsive Tab-1</li>
            <li>Responsive Tab-2</li>
            <li>Responsive Tab-3</li>
          </ul>
          <div class="resp-tabs-container">
            <div>
              <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum nibh urna, euismod ut ornare non, volutpat vel tortor. Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis urna gravida mollis.</p>
            </div>
            <div>
              <p>This tab has icon in consectetur adipiscing eliconse consectetur adipiscing elit. Vestibulum nibh urna, ctetur adipiscing elit. Vestibulum nibh urna, t.consectetur adipiscing elit. Vestibulum nibh urna,  Vestibulum nibh urna,it.</p>
            </div>
            <div>
              <p>Suspendisse blandit velit Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis urna gravid urna gravid eget erat suscipit in malesuada odio venenatis.</p>
            </div>
          </div>
        </div>
        <!-- Responsive Tab end --> 
        <br>
        <!-- Responsive Vertical Tab
        ============================================= -->
        <h5 class="mb-3">Responsive Vertical Tab</h5>
        <p class="text-info">Resize your Browser to see the Tabs change into Accordions</p>
        <div class="bg-light px-4 py-5">
          <div id="verticalTab">
            <div class="row g-0">
              <div class="col-md-3 my-0 my-md-3">
                <ul class="resp-tabs-list">
                  <li>Responsive Tab-1</li>
                  <li>Responsive Tab-2</li>
                  <li>Responsive Tab-3</li>
                </ul>
              </div>
              <div class="col-md-9">
                <div class="resp-tabs-container bg-white shadow-md rounded h-100 p-2">
                  <div>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum nibh urna, euismod ut ornare non, volutpat vel tortor. Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis urna gravida mollis.</p>
                  </div>
                  <div>
                    <p>This tab has icon in consectetur adipiscing eliconse consectetur adipiscing elit. Vestibulum nibh urna, ctetur adipiscing elit. Vestibulum nibh urna, t.consectetur adipiscing elit. Vestibulum nibh urna,  Vestibulum nibh urna,it.</p>
                  </div>
                  <div>
                    <p>Suspendisse blandit velit Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis Integer laoreet placerat suscipit. Sed sodales scelerisque commodo. Nam porta cursus lectus. Proin nunc erat, gravida a facilisis quis, ornare id lectus. Proin consectetur nibh quis urna gravid urna gravid eget erat suscipit in malesuada odio venenatis.</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- Responsive Vertical Tab end --> 
        <!-- Tabs end -->
        
        <h2 class="text-center my-5">Partner</h2>
        <!-- Partner (Grid)
        ============================================= -->
        <h5>Grid</h5>
        <hr>
        <div class="brands-grid separator-border">
          <div class="row align-items-center">
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-1.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-2.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-3.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-4.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-5.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-6.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-7.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-8.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-9.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-10.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-11.png" alt="Brands"></a></div>
            <div class="col-6 col-sm-3 col-lg-2 text-center"><a href=""><img class="img-fluid" src="images/partner/partner-1.png" alt="Brands"></a></div>
          </div>
        </div>
        <!-- Partner (Grid) end --> 
        
        <!-- Partner (Carousel)
        ============================================= -->
        <h5 class="mt-4">Carousel</h5>
        <hr>
        <div class="owl-carousel owl-theme" data-autoplay="true" data-nav="true" data-loop="true" data-margin="30" data-slideby="2" data-stagepadding="5" data-items-xs="2" data-items-sm="3" data-items-md="4" data-items-lg="6">
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-1.png" alt="partner 1" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-2.png" alt="partner 2" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-3.png" alt="partner 3" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-8.png" alt="partner 4" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-5.png" alt="partner 5" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-11.png" alt="partner 6" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-7.png" alt="partner 7" /></a></div>
          <div class="item"><a href="#"><img class="img-fluid" src="images/partner/partner-9.png" alt="partner 11" /></a></div>
        </div>
        <!-- Partner (Carousel) end -->
        
        <hr>
        
        <!-- Social Icons
        ============================================= -->
        <h2 class="my-5 text-center">Social Icons</h2>
        <div class="row">
          <div class="col-sm-4">
            <h5 class="mb-3">Dark (Regular)</h5>
            <div class="d-flex flex-column mb-3">
              <ul class="social-icons">
                <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
                <li class="social-icons-linkedin"><a data-bs-toggle="tooltip" href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                <li class="social-icons-instagram"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                <li class="social-icons-reddit"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="reddit"><i class="fab fa-reddit"></i></a></li>
                <li class="social-icons-vk"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vk"><i class="fab fa-vk"></i></a></li>
                <li class="social-icons-rss"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="rss"><i class="fas fa-rss"></i></a></li>
                <li class="social-icons-skype"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="skype"><i class="fab fa-skype"></i></a></li>
                <li class="social-icons-xing"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="xing"><i class="fab fa-xing"></i></a></li>
                <li class="social-icons-tumblr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="tumblr"><i class="fab fa-tumblr"></i></a></li>
                <li class="social-icons-email"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Email"><i class="fas fa-envelope"></i></a></li>
                <li class="social-icons-delicious"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Delicious"><i class="fab fa-delicious"></i></a></li>
                <li class="social-icons-stumbleupon"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Stumbleupon"><i class="fab fa-stumbleupon"></i></a></li>
                <li class="social-icons-digg"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="digg"><i class="fab fa-digg"></i></a></li>
                <li class="social-icons-blogger"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Blogger"><i class="fab fa-blogger-b"></i></a></li>
                <li class="social-icons-flickr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="flickr"><i class="fab fa-flickr"></i></a></li>
                <li class="social-icons-vimeo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vimeo"><i class="fab fa-vimeo-v"></i></a></li>
                <li class="social-icons-yahoo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="yahoo"><i class="fab fa-yahoo"></i></a></li>
                <li class="social-icons-googleplay"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Google Play"><i class="fab fa-google-play"></i></a></li>
                <li class="social-icons-apple"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="apple"><i class="fab fa-apple"></i></a></li>
              </ul>
            </div>
          </div>
          <div class="col-sm-4">
            <h5 class="mb-3">Light</h5>
            <div class="bg-dark-4 px-2 pt-2 pb-0">
              <div class="d-flex flex-column mb-3">
                <ul class="social-icons social-icons-light">
                  <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                  <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                  <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
                  <li class="social-icons-linkedin"><a data-bs-toggle="tooltip" href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                  <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                  <li class="social-icons-instagram"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                  <li class="social-icons-reddit"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="reddit"><i class="fab fa-reddit"></i></a></li>
                  <li class="social-icons-vk"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vk"><i class="fab fa-vk"></i></a></li>
                  <li class="social-icons-rss"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="rss"><i class="fas fa-rss"></i></a></li>
                  <li class="social-icons-skype"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="skype"><i class="fab fa-skype"></i></a></li>
                  <li class="social-icons-xing"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="xing"><i class="fab fa-xing"></i></a></li>
                  <li class="social-icons-tumblr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="tumblr"><i class="fab fa-tumblr"></i></a></li>
                  <li class="social-icons-email"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Email"><i class="fas fa-envelope"></i></a></li>
                  <li class="social-icons-delicious"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Delicious"><i class="fab fa-delicious"></i></a></li>
                  <li class="social-icons-stumbleupon"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Stumbleupon"><i class="fab fa-stumbleupon"></i></a></li>
                  <li class="social-icons-digg"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="digg"><i class="fab fa-digg"></i></a></li>
                  <li class="social-icons-blogger"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Blogger"><i class="fab fa-blogger-b"></i></a></li>
                  <li class="social-icons-flickr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="flickr"><i class="fab fa-flickr"></i></a></li>
                  <li class="social-icons-vimeo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vimeo"><i class="fab fa-vimeo-v"></i></a></li>
                  <li class="social-icons-yahoo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="yahoo"><i class="fab fa-yahoo"></i></a></li>
                  <li class="social-icons-googleplay"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Google Play"><i class="fab fa-google-play"></i></a></li>
                  <li class="social-icons-apple"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="apple"><i class="fab fa-apple"></i></a></li>
                </ul>
              </div>
            </div>
          </div>
          <div class="col-sm-4">
            <h5 class="mb-3">Colored</h5>
            <div class="d-flex flex-column mb-3">
              <ul class="social-icons social-icons-colored">
                <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
                <li class="social-icons-linkedin"><a data-bs-toggle="tooltip" href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                <li class="social-icons-instagram"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                <li class="social-icons-reddit"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="reddit"><i class="fab fa-reddit"></i></a></li>
                <li class="social-icons-vk"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vk"><i class="fab fa-vk"></i></a></li>
                <li class="social-icons-rss"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="rss"><i class="fas fa-rss"></i></a></li>
                <li class="social-icons-skype"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="skype"><i class="fab fa-skype"></i></a></li>
                <li class="social-icons-xing"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="xing"><i class="fab fa-xing"></i></a></li>
                <li class="social-icons-tumblr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="tumblr"><i class="fab fa-tumblr"></i></a></li>
                <li class="social-icons-email"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Email"><i class="fas fa-envelope"></i></a></li>
                <li class="social-icons-delicious"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Delicious"><i class="fab fa-delicious"></i></a></li>
                <li class="social-icons-stumbleupon"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Stumbleupon"><i class="fab fa-stumbleupon"></i></a></li>
                <li class="social-icons-digg"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="digg"><i class="fab fa-digg"></i></a></li>
                <li class="social-icons-blogger"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Blogger"><i class="fab fa-blogger-b"></i></a></li>
                <li class="social-icons-flickr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="flickr"><i class="fab fa-flickr"></i></a></li>
                <li class="social-icons-vimeo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vimeo"><i class="fab fa-vimeo-v"></i></a></li>
                <li class="social-icons-yahoo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="yahoo"><i class="fab fa-yahoo"></i></a></li>
                <li class="social-icons-googleplay"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Google Play"><i class="fab fa-google-play"></i></a></li>
                <li class="social-icons-apple"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="apple"><i class="fab fa-apple"></i></a></li>
              </ul>
            </div>
          </div>
          <div class="col-sm-4">
            <h5 class="mb-3">Small Icon</h5>
            <div class="d-flex flex-column mb-3">
              <ul class="social-icons social-icons-sm">
                <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
                <li class="social-icons-linkedin"><a data-bs-toggle="tooltip" href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                <li class="social-icons-instagram"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                <li class="social-icons-reddit"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="reddit"><i class="fab fa-reddit"></i></a></li>
                <li class="social-icons-vk"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vk"><i class="fab fa-vk"></i></a></li>
                <li class="social-icons-rss"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="rss"><i class="fas fa-rss"></i></a></li>
                <li class="social-icons-skype"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="skype"><i class="fab fa-skype"></i></a></li>
                <li class="social-icons-xing"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="xing"><i class="fab fa-xing"></i></a></li>
                <li class="social-icons-tumblr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="tumblr"><i class="fab fa-tumblr"></i></a></li>
                <li class="social-icons-email"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Email"><i class="fas fa-envelope"></i></a></li>
                <li class="social-icons-delicious"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Delicious"><i class="fab fa-delicious"></i></a></li>
                <li class="social-icons-stumbleupon"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Stumbleupon"><i class="fab fa-stumbleupon"></i></a></li>
                <li class="social-icons-digg"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="digg"><i class="fab fa-digg"></i></a></li>
                <li class="social-icons-blogger"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Blogger"><i class="fab fa-blogger-b"></i></a></li>
                <li class="social-icons-flickr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="flickr"><i class="fab fa-flickr"></i></a></li>
                <li class="social-icons-vimeo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vimeo"><i class="fab fa-vimeo-v"></i></a></li>
                <li class="social-icons-yahoo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="yahoo"><i class="fab fa-yahoo"></i></a></li>
                <li class="social-icons-googleplay"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Google Play"><i class="fab fa-google-play"></i></a></li>
                <li class="social-icons-apple"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="apple"><i class="fab fa-apple"></i></a></li>
              </ul>
            </div>
          </div>
          <div class="col-sm-4">
            <h5 class="mb-3">Large Icon</h5>
            <div class="d-flex flex-column mb-3">
              <ul class="social-icons social-icons-lg">
                <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
                <li class="social-icons-linkedin"><a data-bs-toggle="tooltip" href="http://www.linkedin.com/" target="_blank" title="Linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                <li class="social-icons-instagram"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                <li class="social-icons-reddit"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="reddit"><i class="fab fa-reddit"></i></a></li>
                <li class="social-icons-vk"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vk"><i class="fab fa-vk"></i></a></li>
                <li class="social-icons-rss"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="rss"><i class="fas fa-rss"></i></a></li>
                <li class="social-icons-skype"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="skype"><i class="fab fa-skype"></i></a></li>
                <li class="social-icons-xing"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="xing"><i class="fab fa-xing"></i></a></li>
                <li class="social-icons-tumblr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="tumblr"><i class="fab fa-tumblr"></i></a></li>
                <li class="social-icons-email"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Email"><i class="fas fa-envelope"></i></a></li>
                <li class="social-icons-delicious"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Delicious"><i class="fab fa-delicious"></i></a></li>
                <li class="social-icons-stumbleupon"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Stumbleupon"><i class="fab fa-stumbleupon"></i></a></li>
                <li class="social-icons-digg"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="digg"><i class="fab fa-digg"></i></a></li>
                <li class="social-icons-blogger"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Blogger"><i class="fab fa-blogger-b"></i></a></li>
                <li class="social-icons-flickr"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="flickr"><i class="fab fa-flickr"></i></a></li>
                <li class="social-icons-vimeo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="vimeo"><i class="fab fa-vimeo-v"></i></a></li>
                <li class="social-icons-yahoo"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="yahoo"><i class="fab fa-yahoo"></i></a></li>
                <li class="social-icons-googleplay"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Google Play"><i class="fab fa-google-play"></i></a></li>
                <li class="social-icons-apple"><a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="apple"><i class="fab fa-apple"></i></a></li>
              </ul>
            </div>
          </div>
        </div>
        <!-- Social Icons end --> 
      </div>
    </div>
  </div>
  <!-- Content end --> 
  
  <!-- Footer
  ============================================= -->
  <footer id="footer">
    <div class="container">
      <div class="row">
        <div class="col-lg d-lg-flex align-items-center">
          <ul class="nav justify-content-center justify-content-lg-start text-3">
            <li class="nav-item"> <a class="nav-link active" href="#">About Us</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Support</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Help</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Careers</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Affiliate</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Fees</a></li>
          </ul>
        </div>
        <div class="col-lg d-lg-flex justify-content-lg-end mt-3 mt-lg-0">
          <ul class="social-icons justify-content-center">
            <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
            <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
            <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
            <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
          </ul>
        </div>
      </div>
      <div class="footer-copyright pt-3 pt-lg-2 mt-2">
        <div class="row">
          <div class="col-lg">
            <p class="text-center text-lg-start mb-2 mb-lg-0">Copyright &copy; <?php echo date("Y"); ?> <a>Guardian Trust - United</a>. All Rights Reserved.</p>
          </div>
          <div class="col-lg d-lg-flex align-items-center justify-content-lg-end">
            <ul class="nav justify-content-center">
              <li class="nav-item"> <a class="nav-link active" href="#">Security</a></li>
              <li class="nav-item"> <a class="nav-link" href="#">Terms</a></li>
              <li class="nav-item"> <a class="nav-link" href="#">Privacy</a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <!-- Footer end --> 
  
</div>
<!-- Document Wrapper end --> 

<!-- Back to Top
============================================= --> 
<a id="back-to-top" data-bs-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a> 

<!-- Styles Switcher -->

<!-- Styles Switcher End --> 

<!-- Script --> 
<script src="vendor/jquery/jquery.min.js"></script> 
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script> 
<script src="vendor/owl.carousel/owl.carousel.min.js"></script> 
<script src="vendor/easy-responsive-tabs/easy-responsive-tabs.js"></script> 
<!-- Style Switcher --> 
<script src="js/switcher.min.js"></script> 
<script src="js/theme.js"></script> 
<script>
$(document).ready(function () {
$('#horizontalTab').easyResponsiveTabs({
type: 'default', //Types: default, vertical, accordion          
});
$('#verticalTab').easyResponsiveTabs({
type: 'vertical', //Types: default, vertical, accordion
});
});
</script>
</body>
</html>